// CmdParam.h: interface for the CCmdParam class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CMDPARAM_H__AA073DC8_4FF0_4BD0_A9DE_2078C4AF2F6C__INCLUDED_)
#define AFX_CMDPARAM_H__AA073DC8_4FF0_4BD0_A9DE_2078C4AF2F6C__INCLUDED_

#include <afxtempl.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#pragma warning (disable : 4251)
#pragma warning (disable : 4275)
/////////////////////////////////////////////////////////////////////////////

#define TYPE_STRING 0
#define TYPE_INT	1
#define TYPE_DOUBLE	2
#define TYPE_FLAG	4
/////////////////////////////////////////////////////////////////////////////
typedef struct _StructRange
{
	int type; // 0 String, 1 int, 2 char
	CString val;	
	double min;
	double max;
	bool flag;
	char auth;
} StructRange;
/////////////////////////////////////////////////////////////////////////////
struct StructParam 
{
	char* paramName;
	int paramType; // -1  l'init, 0=string, 1=integer	
	int group;
	char* valueString;
	int valueInt;
	bool valueFlag;
	double valueDouble;
	char* range;	
	bool repeatedParam;
	// true if the parameter can't be omitted
	// a param is omitted if it has no value and preceded by ","
	bool mandatory;
	// if param was mandayory bt omitted, return this error
	int  mandatoryErr;
};
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CCmdParam : public CObject
{
private:
	CString		name;
	int			type;
	int			group;	
	CString		valueString;
	int			valueInt;	
	bool		valueFlag;
	double		valueDouble;
	CList<StructRange,StructRange&> mRangeList;
	CString		mRangeDefinition;	
	bool		mRepeatedParam;
	bool		mRepeatedParamLeft;
	// a parameter can keep it's default value because it has not been setted 
	// or because it has been left
	bool		mProcessed;
	bool		mMandatory;
	int			mMandatoryErr;


public:
	CCmdParam();
	CCmdParam(CString name, int type, int group);
	CCmdParam(CCmdParam* iParamP);
	CCmdParam(StructParam structParam);
	virtual ~CCmdParam();

	CString		GetName();
	int			GetType();
	int			GetGroup();
	int			GetValueInt();
	CString		GetValueString();
	bool		GetValueFlag();
	double		GetValueDouble();
	CString		GetRangeDefinition();
	CString		GetAuthChar();
	void		SetName(CString s);
	void		SetType(int t);
	void		SetGroup(int g);
	void		SetRangeDefinition(CString iRangeDef);
	void		SetAuthChar(CString iAuthChar);
	bool		SetValue(int iValue);
	bool		SetValue(CString iValue);
	bool		SetValue(bool iValue, CString iFlagName);
	bool		SetValue(double iValue);
	bool		InRange(int iValue);
	bool		InRange(CString iValue);	
	bool		InRange(double iValue);
	bool		IsCorrect(CString iValue);
	CString		ToString(CString iPrefix);
	void		ParseRange();
	void		ParseTokenRange(CString iRange);
	CList<StructRange,StructRange&>* GetRange();
	
	bool		IsRepeatedParam();
	void		SetRepeatedParam(bool iRepeatedParam);
	bool		IsParamLeft();
	void		SetParamLeft(bool iParamLeft);
	// true if value of parameter has been set with a value or not
	bool		IsProcessed() {return mProcessed;};
	void		SetProcessed() {mProcessed=true;};
	bool		IsMandatory() {return mMandatory;};
	void		SetMandatory(bool iState) {mMandatory=iState;};
	int			GetMandatoryErr() {return mMandatoryErr;};
	void		SetMandatoryErr(int iErr) {mMandatoryErr=iErr;};
};

#endif // !defined(AFX_CMDPARAM_H__AA073DC8_4FF0_4BD0_A9DE_2078C4AF2F6C__INCLUDED_)
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// TokenEx.h: interface for the CTokenEx class.
//
//
//	MFC Simple CString Tokenizer (Version 1)
//	
//	Written by Daniel Madden (daniel.madden@compaq.com)
//  Copyright (c) 1999
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed unmodified by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name and all copyright 
// notices remains intact. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability for any damage/loss of business that
// this product may cause.
//
// Please use and enjoy. Please let me know of any bugs/mods/improvements 
// that you have found/implemented and I will fix/incorporate them into this
// file. 
//
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TOKENEX_H__7CEAEBEE_D15D_11D2_9CA9_444553540000__INCLUDED_)
#define AFX_TOKENEX_H__7CEAEBEE_D15D_11D2_9CA9_444553540000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class COMMON_API CTokenEx  
{
public:
	CTokenEx();
	~CTokenEx();

   
	/*
     @FUNCTION: Splits a Path into 4 parts (Directory, Drive, Filename, Extention).
          NOTE: Supports UNC path names.
       @PARAM1: Whether the Supplied Path (PARAM2) contains a directory name only
                or a file name (Reason: some directories will end with "xxx.xxx"
                which is like a file name).
       @PARAM2: Path to Split.
       @PARAM3: (Referenced) Directory.
       @PARAM4: (Referenced) Drive.
       @PARAM5: (Referenced) Filename.
       @PARAM6: (Referenced) Extention.
	*/
	void SplitPath(BOOL UsingDirsOnly, CString Path, CString& Drive, CString& Dir, CString& FName, CString& Ext);

	/*
     @FUNCTION: Splits a CString into an CStringArray according the Deliminator.
	      NOTE: Supports UNC path names.
       @PARAM1: Source string to be Split.
       @PARAM2: Deliminator.
       @PARAM3: (Referenced) CStringArray to Add to.
    */
	void Split(CString Source, CString Deliminator, CStringArray& AddIt);
  
	/*
     @FUNCTION: Joins a CStringArray to create a CString according the Deliminator.
       @PARAM1: Deliminator.
       @PARAM2: (Referenced) CStringArray to Add to.
    */
	CString Join(CString Deliminator, CStringArray& AddIt);

	/*
     @FUNCTION: Returns the first string found (according to the token given). If the
	            string does not contain a token, then it returns the first param. 
	      NOTE: This uses a REFERENCE as the first param, so everytime it finds
	            a token, the string (& deliminator) are removed from the referenced
	            string.  SEE CODE EXAMPLE!
       @PARAM1: (Referenced) csRefered.
       @PARAM2: Deliminator.
    */
	CString GetString(CString &csRefered, CString Deliminator);

protected:

};

#endif // !defined(AFX_TOKENEX_H__7CEAEBEE_D15D_11D2_9CA9_444553540000__INCLUDED_)
